#!/bin/bash

# Should be set explicitly in the dockerfile
if [[ -z "$MAIN_CLASS" ]]; then
  echo "Main class was not set. Exiting!"
  exit -1
fi

# NAMESPACE should be set in the k8 deployment/pod spec
if [[ -z "$NAMESPACE" ]]; then
  echo "NAMESPACE was not set. Exiting!"
  exit -1
fi

if [ "$USE_ENVCONSUL" == "false" ]; then
  # Start the Java process without envconsul
  echo "Environment configuration will not use Consul"
  if [ "$USE_VAULT_AGENT" == "true" ]; then
    echo "Retreving secrets from Vault Agent"
    source /vault/secrets/config
  fi
  exec /run-service.sh
else
  echo "Using Consul for configuration"


  #/opt/vamf/service/printEnv.sh

  # Source environment variables from Consul/Vault and start the Java process with envconsul
  exec /setEnv.sh

fi
