#!/bin/bash

#/opt/vamf/service/printEnv.sh

if [[ "$USE_ENVCONSUL" != "false" ]]; then
    # If a P12 file is specified in consul, write it to disk and configure the JVM to use it for a key store
    if [[ -n "$SVC_KEY_P12" ]]; then
        # Ensure the password is provided, if not fail the container
        if [[ -z "$SVC_KEY_P12_PWD" ]]; then
            echo "P12 file password not provided, please set the environment variable: SVC_KEY_P12_PWD"
            echo "Exiting"
            exit -1
        else
            echo $SVC_KEY_P12 | base64 -di > svc_private_key.p12
            if [[ -e svc_private_key.p12 ]]; then
                echo "Configuring the JVM keystore"
                JAVA_OPTS="$JAVA_OPTS -Djavax.net.ssl.keyStore=./svc_private_key.p12"
                JAVA_OPTS="$JAVA_OPTS -Djavax.net.ssl.keyStoreType=PKCS12"
                JAVA_OPTS="$JAVA_OPTS -Djavax.net.ssl.keyStorePassword=$SVC_KEY_P12_PWD"
            fi
        fi
    else
        echo "The SVC_KEY_P12 environment variable was not set, not configuring the JVM keystore"
    fi
fi

if [[ "$DEBUG_JAVA_OPTS" != "false" ]]; then
    echo "DEBUG_JAVA_OPTS environment variable is defined - appending additional options to JAVA_OPTS"
    JAVA_OPTS="$JAVA_OPTS $DEBUG_JAVA_OPTS"
else
    echo "The DEBUG_JAVA_OPTS environment variable was not set, using default JAVA_OPTS."
fi

echo "Starting service"
exec java $JAVA_OPTS -cp "/opt/vamf/service/lib/*:/opt/vamf/service/lib" $MAIN_CLASS --spring.config.name=common,application
