#!/bin/bash

# Removes elements from an array based on a given regex pattern.
# Usage: filter_arr pattern array
# Usage: filter_arr pattern element1 element2 ...
filter_arr() {
    arr=($@)
    arr=(${arr[@]:1})
    dirs=($(for i in ${arr[@]}
        do echo $i
    done | grep -v $1))
    echo ${dirs[@]}
}

# Check if there are any duplicate dependencies, if so exit
array=($(ls /opt/vamf/service/lib | sed 's/-[0-9].*$//' | uniq -d))

#echo "======== All array ===="
all=$(ls /opt/vamf/service/lib)
#printf '%s\n' "${all[@]}"

#echo "======== Original array ===="
#printf '%s\n' "${array[@]}"

#echo "======== Filtered array ===="
array=(`filter_arr "^swagger" ${array[@]}`)
#printf '%s\n' "${array[@]}"

printf "%s\n" "${array[@]}"
arraySize=${#array[@]}

if [ "$arraySize" -ne "0" ];
then
    echo "Duplicate Dependencies found:"
    echo "-----------------------------"
    printf "%s\n" "${array[@]}"
    #This is intentionally a hard and non-negotiable check. Do NOT disable.
    exit -1
fi

# Should be set explicitly in the dockerfile
if [[ -z "$MAIN_CLASS" ]]; then
  echo "Main class was not set. Exiting!"
  exit -1
fi

# NAMESPACE should be set in the k8 deployment/pod spec
if [[ -z "$NAMESPACE" ]]; then
  echo "NAMESPACE was not set. Exiting!"
  exit -1
fi

if [ "$USE_ENVCONSUL" == "false" ]; then
  # Start the Java process without envconsul
  exec /opt/vamf/service/run-service.sh
else
  echo "Using Consul for configuration"


  #/opt/vamf/service/printEnv.sh

  # Source environment variables from Consul/Vault and start the Java process with envconsul
  exec /opt/vamf/service/setEnv.sh

fi
